/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.incident;

import com.ibm.hwmca.fw.pa.incident.Incident;
import com.ibm.hwmca.fw.pa.incident.IncidentTimerInterface;
import com.ibm.hwmca.xfw.pa.util.CommonPaLogger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public final class IncidentTimer
extends TimerTask {
    private static Timer timer = new Timer(true);
    private List listeners = new ArrayList();
    private Incident incident = null;

    static void terminate() {
        timer.cancel();
        timer = null;
    }

    IncidentTimer(Incident incident) {
        this.incident = incident;
    }

    public Incident getIncident() {
        return this.incident;
    }

    synchronized void addListener(IncidentTimerInterface listener) {
        this.listeners.add(listener);
    }

    synchronized void removeListener(IncidentTimerInterface listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public synchronized void run() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((IncidentTimerInterface)iterator.next()).timerPopped(this);
            }
            catch (Exception error) {
                error.printStackTrace();
                CommonPaLogger.logIt((short)4114, 0, (Throwable)error, false);
            }
        }
    }

    public synchronized boolean cancel() {
        if (timer == null) {
            return false;
        }
        boolean rc = super.cancel();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((IncidentTimerInterface)iterator.next()).timerCanceled(this);
        }
        return rc;
    }

    void clear() {
        if (timer == null) {
            return;
        }
        super.cancel();
    }

    public long scheduledExecutionTime() {
        if (timer == null) {
            return 0L;
        }
        return this.scheduledExecutionTime();
    }

    void schedule(Date firstTime, long period) {
        if (timer != null) {
            timer.schedule((TimerTask)this, firstTime, period);
        }
    }

    void schedule(long delay) {
        if (timer != null) {
            timer.schedule((TimerTask)this, delay);
        }
    }

    void schedule(Date time) {
        if (timer != null) {
            timer.schedule((TimerTask)this, time);
        }
    }

    void schedule(long delay, long period) {
        if (timer != null) {
            timer.schedule((TimerTask)this, delay, period);
        }
    }

    void scheduleAtFixedRate(long delay, long period) {
        if (timer == null) {
            timer.scheduleAtFixedRate((TimerTask)this, delay, period);
        }
    }
}

